package gov.cms.grouper.snf.util.reader;

import gov.cms.grouper.snf.model.reader.Rai300;
import gov.cms.grouper.snf.transfer.SnfClaim;
import gov.cms.grouper.snf.util.ClaimInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnfDataMapperTest {

  @Test
  public void testNursingRecord() {
    String record = "MDS       NC 1.17      3.00      PIA765045          521230861CMS"
        + "                           help@qtso.com                                     jRAVEN"
        + "                                            1.1.9"
        + "               ^                   ^         765045      ^              10101  "
        + "0103FPDPMf150   ^GrprNRSEf150      ^  9990211505GR1PR1NR50 ^              "
        + "1193205010000010^              4^           ^         ^                      ^   "
        + "                   0100000201910011012019100601^       201910060^       ^       "
        + "0010000112121222120^^^^^^^^     111101111111111111108 ^^^^^^^^^^^^^^^^^^^^^  "
        + "0010000^^^^^^00^^31111212232332221110^^^^^^^^^^^^^^^^^^^^^"
        + "11110000000000000000000000000000010000010---"
        + "0000011000000000000001000000000000000100000010000010000000000"
        + "^       ^       ^       ^       ^       ^       ^       ^       ^       ^       "
        + "00010^^^^ ^^^^^^^^100000000011110^^^00010671272       00000001000100^^^        "
        + "^^^^^^^^^^                    0000000100000000010^^        0000000001010001000000 "
        + "0010120191001^1^200 -   -   52019100120191005200 -   -   52019100120191005200 -   "
        + "-   5201910012019100515  115  115  17700006000- - 00000000109^^1  ^2049920191001"
        + "- - - 0-1-0-0-1-1-101-0-1010100-100-10100-0-0-20191006201910061^^           ^"
        + "                 ^^       ^        ^ ^    ^       ^       ^       ^ ^^^^^^^^"
        + "           ^                 ^       KIAA1  1.0003                      RAA"
        + "       1.0448    RAA       1.0448    20191006^           1^^^01100 1 000001234567"
        + "^^^ 32 12-   -   -   520191001011000401^ 0501^ 0401^ 0603^ 0605^ 0505^ 0506^ 0502"
        + "^   0603^ 0605^ 1^0404^ 1^0505^ 1^^0112019100512019100511111132181000000605^ 0302"
        + "^ 0709^ 88- ^ 0605^ 0106^ 0403^ 0403^ 0403^ 0403^ 88- ^ 0403^ 13        111^0^1"
        + "^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ A20.7^^^111111111111111111111111111111^   ^   ^   ^   ^  ^"
        + "   ^   ^   ^   ^  ^   ^   ^   ^   ^  ^    ^"
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                                 "
        + "                                                                               %";

    SnfDataMapper mapper = new SnfDataMapper();

    SnfClaim claim = mapper.mapMdsToClaim(record, Rai300.values());

    Assertions.assertEquals("A20.7^^^", claim.getPrimaryDiagnosis().getValue());
    Assertions.assertEquals(1, claim.getAiCode().intValue());

    ClaimInfo claimUtil = new ClaimInfo(100, false, claim.getAssessments());

    Assertions.assertEquals(7, claimUtil.getAssessmentValue(Rai300.O0500A));
  }

}
